# 機能設計書 7-Google Analytics設定

## 概要

本ドキュメントは、QuickerSite CMSのGoogle Analytics設定機能について記述する。

### 本機能の処理概要

本機能は、Google Analyticsのトラッキングコードを設定・管理するための機能を提供する。設定されたコードはサイトの全ページに自動的に挿入され、アクセス解析データの収集を可能にする。

**業務上の目的・背景**：Webサイトのアクセス解析はマーケティング戦略の基盤となる重要な要素である。Google Analyticsを導入することで、訪問者数、ページビュー、滞在時間、離脱率、流入元などの詳細なデータを取得でき、サイト改善やコンテンツ戦略の立案に活用できる。

**機能の利用シーン**：
- サイト新規構築時のGoogle Analytics導入
- トラッキングコードの更新（UAからGA4への移行等）
- アクセス解析の開始・停止
- 複数のトラッキングコード設定

**主要な処理内容**：
1. Google Analyticsトラッキングコードの設定
2. コードの保存とサイト全体への適用
3. トラッキングコードの削除（空文字設定）

**関連システム・外部連携**：Google Analytics

**権限による制御**：secondAdmin.bSetupGeneral 権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 変数設定 | 主画面 | Google Analyticsコードの設定 |
| 136 | 顧客詳細 | 参照画面 | クライアント詳細情報の表示 |
| 137 | 顧客編集 | 参照画面 | サイト顧客の編集 |

## 機能種別

設定管理 / 外部サービス連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| googleAnalytics | String | No | Google Analyticsトラッキングコード | 制限なし |

### 入力データソース

- 画面入力（設定フォーム bs_admin.asp）

### 入力形式

Google Analyticsコードは以下の形式で入力される：

**旧Universal Analytics形式（UA）**:
```html
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');
  ga('create', 'UA-XXXXXX-X', 'auto');
  ga('send', 'pageview');
</script>
```

**Google Analytics 4形式（GA4）**:
```html
<script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXXXXX"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-XXXXXXXXXX');
</script>
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.googleAnalytics | String | Google Analyticsトラッキングコード |

### 出力先

- データベース（tblCustomer.googleAnalytics）
- フロントサイトHTMLヘッダー（scriptタグとして出力）

## 処理フロー

### 処理シーケンス

```
1. 基本設定画面アクセス
   └─ secondAdmin.bSetupGeneral権限チェック

2. 現在の設定値読み込み
   └─ customer オブジェクトからgoogleAnalyticsを取得

3. フォーム表示
   └─ textareaにGoogle Analyticsコードを表示

4. 保存処理（btnaction="saveAdmin"）
   └─ CSRF検証
   └─ googleAnalyticsフォーム値の取得
   └─ customer.save()
   └─ メニューキャッシュクリア
```

### フローチャート

```mermaid
flowchart TD
    A[基本設定画面] --> B{権限チェック}
    B -->|権限なし| C[bs_default.aspへリダイレクト]
    B -->|権限あり| D[現在のGA設定値読み込み]
    D --> E[フォーム表示]
    E --> F{保存ボタン押下}
    F -->|No| E
    F -->|Yes| G[CSRF検証]
    G --> H[googleAnalytics取得]
    H --> I[customer.save]
    I --> J[メニューキャッシュクリア]
    J --> K[成功メッセージ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | コード任意 | Google Analyticsコードは任意入力 | 常時 |
| BR-02 | 直接記述 | JavaScriptコードをそのまま記述可能 | 常時 |
| BR-03 | 全ページ適用 | 設定されたコードはサイト全体に適用される | 常時 |
| BR-04 | 空文字で無効化 | コードを空文字にするとトラッキングが無効化される | 常時 |

### 計算ロジック

- 特になし（入力値をそのまま保存）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| GA設定読み込み | tblCustomer | SELECT | 現在のGAコード取得 |
| GA設定保存 | tblCustomer | UPDATE | GAコード更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | googleAnalytics | iId = cId | GAコード取得 |
| UPDATE | googleAnalytics | 入力値 | GAコード更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| （なし） | - | Google Analytics項目は任意のためバリデーションエラーは発生しない | - |

### リトライ仕様

- エラー時は同一画面で再入力可能

## トランザクション仕様

- 保存処理: 単一UPDATEで完結

## パフォーマンス要件

- 設定保存: 即座に完了
- メニューキャッシュクリア: 即座に完了

## セキュリティ考慮事項

- CSRF対策トークン検証
- secondAdmin.bSetupGeneral 権限チェック
- JavaScriptコードを直接記述可能なため、信頼できる管理者のみがアクセス可能
- 悪意のあるスクリプト挿入のリスクがあるため、権限管理が重要

## 備考

- Google Analytics設定はサイト基本設定画面（No.5）と同一画面で管理される
- 設定画面には Google Analytics 公式サイトへのリンク（?マーク）が表示される
- UA（Universal Analytics）とGA4（Google Analytics 4）の両方のコード形式に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Google Analytics設定のデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのgoogleAnalyticsプロパティ（8行目） |

**読解のコツ**: cls_customerクラスで `googleAnalytics` プロパティがGA設定を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_admin.asp | `asp/bs_admin.asp` | 基本設定画面のメインファイル（11行） |

**主要処理フロー**:
1. **4行目**: secondAdmin.bSetupGeneral 権限チェック
2. **10行目**: フォーム表示（googleAnalyticsのtextareaタグ）

**GA関連フォーム要素**:
```html
<textarea name="googleAnalytics" cols=40 rows=2>...</textarea>
<a target=google href="http://www.google.com/analytics/">?</a>
```

#### Step 3: 処理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | saveAdmin処理 |

**主要処理フロー**:
- **103-126行目**: saveAdmin処理
- **115行目**: `customer.googleAnalytics = Request.Form("googleAnalytics")`
- **122-126行目**: save()とキャッシュクリア

#### Step 4: データベース保存を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customer.asp | `asp/includes/customer.asp` | save関数のgoogleAnalyticsカラム更新 |

**主要処理フロー**:
- **127行目**: `rs("googleAnalytics") = rs("googleAnalytics")` (Pick時)
- **374行目**: `rs("googleAnalytics") = googleAnalytics` (Save時)

### プログラム呼び出し階層図

```
bs_admin.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/customer.asp（cls_customerクラス）
    │
    ├─ bs_security.asp（認証・権限チェック）
    │      └─ secondAdmin.bSetupGeneral
    │
    ├─ bs_process.asp（処理分岐）
    │      │
    │      └─ btnaction = "saveAdmin"
    │             ├─ CSRF検証（checkCSRF）
    │             ├─ googleAnalytics取得
    │             ├─ customer.save()
    │             └─ clearMenuCache()
    │
    └─ フォーム表示（GA設定入力欄）
           └─ <textarea name="googleAnalytics">
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ────▶ Request.Form取得
(GAコード)              │
                        │
googleAnalytics ────────┼──▶ customer.googleAnalytics
                        │
                        ▼
                  customer.save()
                        │
                        ▼
                  tblCustomer
                  (UPDATE)
                        │
                        ▼
              フロントサイトの
              HTMLヘッダーに出力
              <script>...GA CODE...</script>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_admin.asp | `asp/bs_admin.asp` | ソース | 基本設定画面メインファイル |
| bs_process.asp | `asp/bs_process.asp` | ソース | 処理分岐ロジック（saveAdmin） |
| customer.asp | `asp/includes/customer.asp` | ソース | cls_customerクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
| header.asp | `asp/includes/header.asp` | ソース | GAコード出力処理 |
